# Application de Diagnostic Médical

## Description
Cette application de diagnostic médical est un outil d'aide à la décision médicale qui permet aux utilisateurs de saisir leurs symptômes et d'obtenir des suggestions de diagnostics possibles. L'application utilise un système d'analyse basé sur les probabilités pour associer les symptômes aux maladies potentielles. Elle offre une interface utilisateur intuitive et un tableau de bord d'administration pour gérer les données médicales.

## Fonctionnalités principales

### Pour les utilisateurs
- Création de compte et authentification
- Sélection de symptômes à partir d'une liste organisée par catégories
- Obtention de résultats de diagnostic avec probabilités associées
- Consultation de l'historique des diagnostics précédents
- Gestion du profil utilisateur

### Pour les administrateurs
- Tableau de bord avec statistiques d'utilisation
- Gestion complète des maladies (ajout, modification, suppression)
- Gestion des symptômes par catégories
- Configuration des relations entre maladies et symptômes avec leurs probabilités
- Suivi des activités des utilisateurs

## Prérequis techniques
- Serveur web (WAMP, XAMPP, etc.) avec PHP 7.4 ou supérieur
- MySQL 5.7 ou supérieur
- Navigateur web moderne (Chrome, Firefox, Edge, Safari)

## Installation et démarrage

### 1. Configuration de la base de données
1. Démarrez votre serveur WampServer
2. Accédez à phpMyAdmin (http://localhost/phpmyadmin)
3. Créez une nouvelle base de données nommée `diagnostic_medical`
4. Importez le fichier `diagnostic_medical.sql` situé à la racine du projet

### 2. Configuration de l'application
1. Placez le dossier du projet dans le répertoire `www` de WampServer (généralement `C:\wamp64\www\` ou similaire)
2. Si nécessaire, modifiez les paramètres de connexion à la base de données dans le fichier `app/config/config.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_USER', 'root');
   define('DB_PASS', '');
   define('DB_NAME', 'diagnostic_medical');
   ```
3. Assurez-vous que la constante `APP_URL` pointe vers l'URL correcte de votre application:
   ```php
   define('APP_URL', 'http://localhost/consult');
   ```

### 3. Accès à l'application
1. Ouvrez votre navigateur et accédez à l'URL: `http://localhost/consult`
2. Vous pouvez vous connecter en tant qu'utilisateur ou administrateur:
   - **Compte administrateur**:
     - Email: mbamyborel@gmail.com
     - Mot de passe: dddddd
   - **Compte utilisateur standard** (ou créez votre propre compte):
     - Email: borelmbamy3@gmail.com
     - Mot de passe: dddddd

## Guide d'utilisation

### Utilisateurs standards

#### Réaliser un diagnostic
1. Connectez-vous à votre compte
2. Cliquez sur "Nouveau diagnostic" dans le menu
3. Sélectionnez les symptômes que vous ressentez parmi la liste proposée
4. Cliquez sur "Analyser les symptômes" pour obtenir le résultat
5. Consultez les maladies possibles et leurs probabilités

#### Consulter l'historique
1. Accédez à "Historique de diagnostics" dans le menu
2. Visualisez la liste de vos diagnostics précédents
3. Cliquez sur un diagnostic pour voir les détails

#### Gérer votre profil
1. Cliquez sur votre nom d'utilisateur en haut à droite, puis "Mon profil"
2. Modifiez vos informations personnelles ou votre mot de passe
3. Enregistrez vos modifications

### Administrateurs

#### Gérer les maladies
1. Accédez au tableau de bord administrateur
2. Cliquez sur "Gestion des maladies"
3. Ajoutez, modifiez ou supprimez des maladies

#### Gérer les symptômes
1. Dans le tableau de bord, sélectionnez "Gestion des symptômes"
2. Ajoutez de nouveaux symptômes avec leur catégorie
3. Modifiez ou supprimez des symptômes existants

#### Configurer les relations
1. Accédez à "Gestion des relations"
2. Créez des associations entre maladies et symptômes
3. Définissez les probabilités pour chaque relation

## Structure du projet
```
/consult/
├── app/                    # Cœur de l'application
│   ├── config/             # Configuration de l'application
│   ├── controllers/        # Contrôleurs (logique métier)
│   ├── core/               # Classes fondamentales (Router, Controller, etc.)
│   ├── models/             # Modèles de données
│   └── views/              # Vues (interface utilisateur)
├── public/                 # Fichiers publics
│   ├── assets/             # CSS, JavaScript, images
│   └── index.php           # Point d'entrée
├── .htaccess               # Configuration Apache
├── diagnostic_medical.sql  # Script de base de données
└── index.php               # Routeur principal
```

## Conseils de dépannage
- Si vous rencontrez une erreur "Database connection failed", vérifiez les identifiants de connexion dans `app/config/config.php`
- Si l'application affiche une page blanche, activez l'affichage des erreurs PHP dans votre configuration WAMP
- Pour les problèmes d'affichage, vérifiez la compatibilité de votre navigateur et essayez de vider le cache

## Sécurité
Cette application implémente plusieurs mesures de sécurité:
- Protection contre les injections SQL via l'utilisation de requêtes préparées
- Hachage des mots de passe avec bcrypt
- Validation des données utilisateur
- Gestion sécurisée des sessions

## Avertissement
Cette application est conçue comme un outil d'aide et ne remplace en aucun cas l'avis d'un médecin professionnel. Les résultats de diagnostic fournis sont basés sur des algorithmes et des données prédéfinies, et ne constituent pas un diagnostic médical officiel. Consultez toujours un professionnel de la santé pour toute préoccupation médicale.

## Support
Pour toute question ou problème technique, veuillez contacter l'administrateur système. 