<?php
class AdminController extends Controller {
    private $userModel;
    private $diagnosticModel;
    private $diseaseModel;
    private $symptomModel;

    public function __construct() {
        parent::__construct();
        // Vérifier si l'utilisateur est connecté et est un administrateur
        $this->requireAdmin();
        
        $this->userModel = new User();
        $this->diagnosticModel = new Diagnostic();
        $this->diseaseModel = new Disease();
        $this->symptomModel = new Symptom();
    }

    public function index() {
        $totalUsers = $this->userModel->countUsers();
        $totalDiagnostics = $this->diagnosticModel->countAllDiagnostics();
        $totalDiseases = $this->diseaseModel->countDiseases();
        $totalSymptoms = $this->symptomModel->countSymptoms();
        
        $recentDiagnostics = $this->diagnosticModel->getRecentDiagnostics(5);
        $recentUsers = $this->userModel->getRecentUsers(5);
        
        // Créer un tableau de statistiques
        $stats = [
            'total_users' => $totalUsers,
            'total_diagnostics' => $totalDiagnostics,
            'total_diseases' => $totalDiseases,
            'total_symptoms' => $totalSymptoms
        ];
        
        $this->renderAdmin('admin/index', [
            'title' => 'Tableau de bord',
            'totalUsers' => $totalUsers,
            'totalDiagnostics' => $totalDiagnostics,
            'totalDiseases' => $totalDiseases,
            'totalSymptoms' => $totalSymptoms,
            'recentDiagnostics' => $recentDiagnostics,
            'recentUsers' => $recentUsers,
            'stats' => $stats
        ]);
    }

    public function diseases() {
        $action = $_POST['action'] ?? null;
        
        if ($this->isPost() && $action) {
            $isAjax = (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
            
            switch ($action) {
                case 'add':
                    $name = $_POST['name'] ?? '';
                    $description = $_POST['description'] ?? '';
                    $treatment = $_POST['treatment'] ?? '';
                    
                    $result = $this->diseaseModel->addDisease($name, $description, $treatment);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/diseases');
                    }
                    break;
                    
                case 'edit':
                    $id = $_POST['id'] ?? 0;
            $name = $_POST['name'] ?? '';
            $description = $_POST['description'] ?? '';
                    $treatment = $_POST['treatment'] ?? '';
                    
                    $result = $this->diseaseModel->updateDisease($id, $name, $description, $treatment);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/diseases');
                    }
                    break;
                    
                case 'delete':
                    $id = $_POST['id'] ?? 0;
                    
                    $result = $this->diseaseModel->deleteDisease($id);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/diseases');
                    }
                    break;
            }
        }
        
        $diseases = $this->diseaseModel->getAllDiseases();
        
        $this->renderAdmin('admin/diseases', [
            'title' => 'Gestion des maladies',
            'diseases' => $diseases
        ]);
    }

    public function symptoms() {
        $action = $_POST['action'] ?? null;
        
        if ($this->isPost() && $action) {
            $isAjax = (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
            
            switch ($action) {
                case 'add':
                    $name = $_POST['name'] ?? '';
                    $description = $_POST['description'] ?? '';
                    $category = $_POST['category'] ?? '';
                    
                    $result = $this->symptomModel->addSymptom($name, $description, $category);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/symptoms');
                    }
                    break;
                    
                case 'edit':
                    $id = $_POST['id'] ?? 0;
            $name = $_POST['name'] ?? '';
            $description = $_POST['description'] ?? '';
                    $category = $_POST['category'] ?? '';
                    
                    $result = $this->symptomModel->updateSymptom($id, $name, $description, $category);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/symptoms');
                    }
                    break;
                    
                case 'delete':
                    $id = $_POST['id'] ?? 0;
                    
                    $result = $this->symptomModel->deleteSymptom($id);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/symptoms');
                    }
                    break;
            }
        }
        
        $symptoms = $this->symptomModel->getAllSymptoms();
        
        $this->renderAdmin('admin/symptoms', [
            'title' => 'Gestion des symptômes',
            'symptoms' => $symptoms
        ]);
    }

    public function relations() {
        $action = $_POST['action'] ?? null;
        
        if ($this->isPost() && $action) {
            $isAjax = (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
            
            switch ($action) {
                case 'add':
                    $diseaseId = $_POST['disease_id'] ?? 0;
                    $symptomId = $_POST['symptom_id'] ?? 0;
                    
                    $result = $this->diseaseModel->addRelation($diseaseId, $symptomId);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/relations');
                    }
                    break;
                    
                case 'edit':
                    $id = $_POST['id'] ?? 0;
                    $diseaseId = $_POST['disease_id'] ?? 0;
                    $symptomId = $_POST['symptom_id'] ?? 0;
                    
                    $result = $this->diseaseModel->updateRelation($id, $diseaseId, $symptomId);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/relations');
                    }
                    break;
                    
                case 'delete':
                    $id = $_POST['id'] ?? 0;
                    
                    $result = $this->diseaseModel->deleteRelation($id);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/relations');
                    }
                    break;
            }
        }
        
        $relations = $this->diseaseModel->getAllRelations();
        $diseases = $this->diseaseModel->getAllDiseases();
        $symptoms = $this->symptomModel->getAllSymptoms();
        
        $this->renderAdmin('admin/relations', [
            'title' => 'Gestion des relations',
            'relations' => $relations,
            'diseases' => $diseases,
            'symptoms' => $symptoms
        ]);
    }

    public function users() {
        $action = $_POST['action'] ?? null;
        
        if ($this->isPost() && $action) {
            $isAjax = (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
            
            switch ($action) {
                case 'edit':
                    $id = $_POST['id'] ?? 0;
                    $email = $_POST['email'] ?? '';
                    $firstName = $_POST['first_name'] ?? '';
                    $lastName = $_POST['last_name'] ?? '';
                    $role = $_POST['role'] ?? 'user';
                    
                    $result = $this->userModel->updateUser($id, $email, $firstName, $lastName, $role);
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/users');
                    }
                    break;
                    
                case 'delete':
                    $id = $_POST['id'] ?? 0;
                    
                    // Ne pas permettre à un admin de se supprimer lui-même
                    if ($id == $_SESSION['user_id']) {
                        $result = [
                            'success' => false,
                            'message' => 'Vous ne pouvez pas supprimer votre propre compte.'
                        ];
                    } else {
                        $result = $this->userModel->deleteUser($id);
                    }
                    
                    if ($isAjax) {
                        header('Content-Type: application/json');
                        echo json_encode($result);
                        exit;
                    } else {
                        if ($result['success']) {
                            $_SESSION['success'] = $result['message'];
                        } else {
                            $_SESSION['error'] = $result['message'];
                        }
                        $this->redirect('admin/users');
                    }
                    break;
            }
        }
        
        $users = $this->userModel->getAllUsers();
        
        $this->renderAdmin('admin/users', [
            'title' => 'Gestion des utilisateurs',
            'users' => $users
        ]);
    }

    protected function renderAdmin($view, $data = []) {
        // Extraire les données pour les rendre accessibles dans la vue
        extract($data);
        
        // Capturer le contenu de la vue
        ob_start();
        require_once APP_ROOT . '/views/' . $view . '.php';
        $content = ob_get_clean();
        
        // Afficher le layout principal avec le contenu capturé
        require_once APP_ROOT . '/views/layouts/main.php';
    }
} 