<?php
class Controller {
    public function __construct() {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    protected function render($view, $data = []) {
        // Extraire les données pour les rendre accessibles dans la vue
        extract($data);

        // Inclure le header
        require_once APP_ROOT . '/views/partials/nav.php';

        // Inclure la vue demandée
        require_once APP_ROOT . '/views/' . $view . '.php';

        // Inclure le footer
        require_once APP_ROOT . '/views/layouts/footer.php';
    }

    protected function redirect($url) {
        // Supprimer le slash initial si présent pour éviter les doubles slashes
        $url = ltrim($url, '/');
        
        // Construire l'URL complète
        $redirectUrl = empty($url) ? APP_URL : APP_URL . '/' . $url;
        
        // Vérifier si les headers ont déjà été envoyés
        if (headers_sent()) {
            // Utiliser JavaScript pour la redirection si les headers ont déjà été envoyés
            echo '<script>window.location.href="' . $redirectUrl . '";</script>';
        } else {
            // Sinon, utiliser une redirection HTTP standard
            header('Location: ' . $redirectUrl);
        }
        exit();
    }

    protected function isPost() {
        return $_SERVER['REQUEST_METHOD'] === 'POST';
    }

    protected function isGet() {
        return $_SERVER['REQUEST_METHOD'] === 'GET';
    }

    protected function getPostData() {
        return $_POST;
    }

    protected function getQueryData() {
        return $_GET;
    }

    protected function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }

    protected function requireLogin() {
        if (!$this->isLoggedIn()) {
            $_SESSION['error'] = 'Vous devez être connecté pour accéder à cette page.';
            $this->redirect('auth/login');
        }
    }

    protected function isAdmin() {
        return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
    }

    protected function requireAdmin() {
        if (!$this->isAdmin()) {
            $this->redirect('home');
        }
    }
} 