<?php

class HomeController extends Controller {
    public function __construct() {
        parent::__construct();
    }

    public function index() {
        if ($this->isLoggedIn() && isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin') {
            $this->redirect('admin');
        }
        $this->render('home/index', ['title' => 'Accueil']);
    }

    public function about() {
        if ($this->isLoggedIn() && isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin') {
            $this->redirect('admin');
        }
        $this->render('home/about', ['title' => 'À propos']);
    }

    public function contact() {
        if ($this->isLoggedIn() && isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin') {
            $this->redirect('admin');
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Traiter le formulaire de contact
            $name = $_POST['name'] ?? '';
            $email = $_POST['email'] ?? '';
            $message = $_POST['message'] ?? '';
            
            // TODO: Envoyer l'email ou sauvegarder le message
            
            $_SESSION['success'] = 'Votre message a été envoyé avec succès.';
            $this->redirect('contact');
        }
        
        $this->render('home/contact', ['title' => 'Contact']);
    }

    public function faq() {
        if ($this->isLoggedIn() && isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin') {
            $this->redirect('admin');
        }
        $this->render('home/faq', ['title' => 'FAQ']);
    }
} 