<?php
class Router {
    private $routes = [];
    private $params = [];

    public function __construct() {
        $this->routes = [
            'GET' => [],
            'POST' => []
        ];
    }

    public function get($path, $callback) {
        $this->routes['GET'][$path] = $callback;
    }

    public function post($path, $callback) {
        $this->routes['POST'][$path] = $callback;
    }

    public function dispatch() {
        $method = $_SERVER['REQUEST_METHOD'];
        $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        
        // Supprimer le préfixe /consult/ du chemin
        $path = str_replace('/consult', '', $path);
        $path = '/' . ltrim($path, '/');
        
        if (empty($path)) {
            $path = '/';
        }

        // Debug: Afficher le chemin traité
        error_log("Path being processed: " . $path);

        foreach ($this->routes[$method] as $route => $callback) {
            $pattern = $this->convertToPattern($route);
            
            if (preg_match($pattern, $path, $matches)) {
                array_shift($matches);
                $this->params = $matches;
                
                if (is_callable($callback)) {
                    return call_user_func_array($callback, $this->params);
                } else {
                    list($controller, $action) = explode('@', $callback);
                    return $this->callController($controller, $action);
                }
            }
        }

        // Route par défaut
        if ($path === '/') {
            return $this->callController('HomeController', 'index');
        }

        // Route 404
        header("HTTP/1.0 404 Not Found");
        require_once APP_ROOT . '/views/errors/404.php';
    }

    private function convertToPattern($route) {
        $pattern = preg_replace('/\{([a-zA-Z]+)\}/', '(?P<$1>[^/]+)', $route);
        return '#^' . $pattern . '$#';
    }

    private function callController($controller, $action) {
        $controllerFile = APP_ROOT . '/controllers/' . $controller . '.php';
        
        if (file_exists($controllerFile)) {
            require_once $controllerFile;
            $controllerInstance = new $controller();
            
            // Liste des contrôleurs qui nécessitent une authentification
            $protectedControllers = [
                'DiagnosticController', 
                'AdminController'
            ];
            
            // Si le contrôleur est dans la liste des contrôleurs protégés mais que la méthode requireLogin n'est pas appelée
            // dans le constructeur, vérifier manuellement si l'utilisateur est connecté
            if (in_array($controller, $protectedControllers) && !isset($_SESSION['user_id'])) {
                // Si l'utilisateur n'est pas connecté, rediriger vers la page de connexion
                $_SESSION['error'] = 'Vous devez être connecté pour accéder à cette page.';
                header('Location: ' . APP_URL . '/auth/login');
                exit;
            }
            
            if (method_exists($controllerInstance, $action)) {
                $params = array_values($this->params);
                return call_user_func_array([$controllerInstance, $action], $params);
            }
        }
        
        header("HTTP/1.0 404 Not Found");
        require_once APP_ROOT . '/views/errors/404.php';
    }
} 