<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #007bff;
            --success-color: #28a745;
            --info-color: #17a2b8;
            --warning-color: #ffc107;
            --danger-color: #dc3545;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f5f5;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .stat-card.primary { background-color: var(--primary-color); }
        .stat-card.success { background-color: var(--success-color); }
        .stat-card.info { background-color: var(--info-color); }
        .stat-card.warning { background-color: var(--warning-color); }

        .stat-card i {
            font-size: 3em;
            margin-bottom: 15px;
            color: white;
        }

        .stat-card h5 {
            color: white;
            margin-bottom: 10px;
            font-size: 1.1em;
        }

        .stat-card h3 {
            color: white;
            font-size: 2em;
            margin: 0;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }

        .card-header {
            padding: 15px 20px;
            border-bottom: 1px solid #eee;
        }

        .card-header h5 {
            margin: 0;
            font-size: 1.1em;
        }

        .card-body {
            padding: 20px;
        }

        .table-container {
            overflow-x: auto;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .table th,
        .table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        .table th {
            background-color: var(--light-color);
            font-weight: 600;
        }

        .btn {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 4px;
            text-decoration: none;
            color: white;
            background-color: var(--primary-color);
            border: none;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .btn:hover {
            background-color: #0056b3;
        }

        .btn i {
            margin-right: 5px;
        }

        .actions-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
        }

        .btn-success { background-color: var(--success-color); }
        .btn-success:hover { background-color: #218838; }

        .btn-info { background-color: var(--info-color); }
        .btn-info:hover { background-color: #138496; }

        @media (max-width: 768px) {
            .grid {
                grid-template-columns: repeat(2, 1fr);
            }

            .actions-grid {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 480px) {
            .grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h5>Statistiques du système</h5>
            </div>
            <div class="card-body">
                <div class="grid">
                    <div class="stat-card primary">
                        <i class="fas fa-users"></i>
                        <h5>Utilisateurs</h5>
                        <h3><?= $stats['total_users'] ?? $totalUsers ?? 0 ?></h3>
                    </div>
                    <div class="stat-card success">
                        <i class="fas fa-stethoscope"></i>
                        <h5>Diagnostics</h5>
                        <h3><?= $stats['total_diagnostics'] ?? $totalDiagnostics ?? 0 ?></h3>
                    </div>
                    <div class="stat-card info">
                        <i class="fas fa-virus"></i>
                        <h5>Maladies</h5>
                        <h3><?= $stats['total_diseases'] ?? $totalDiseases ?? 0 ?></h3>
                    </div>
                    <div class="stat-card warning">
                        <i class="fas fa-notes-medical"></i>
                        <h5>Symptômes</h5>
                        <h3><?= $stats['total_symptoms'] ?? $totalSymptoms ?? 0 ?></h3>
            </div>
        </div>
    </div>
</div>

        <div class="grid">
            <div class="card" style="grid-column: span 2;">
            <div class="card-header">
                    <h5>Diagnostics récents</h5>
            </div>
            <div class="card-body">
                    <div class="table-container">
                        <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Utilisateur</th>
                                <th>Date</th>
                                <th>Diagnostic</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentDiagnostics as $diagnostic): ?>
                                <tr>
                                    <td><?= $diagnostic['id'] ?></td>
                                    <td><?= $diagnostic['user_email'] ?></td>
                                    <td><?= date('Y-m-d', strtotime($diagnostic['created_at'])) ?></td>
                                    <td><?= $diagnostic['top_disease'] ?? 'Non déterminé' ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                    <a href="<?= APP_URL ?>/admin/diagnostics" class="btn" style="margin-top: 15px;">Voir tous les diagnostics</a>
                </div>
            </div>

            <div class="card" style="grid-column: span 2;">
            <div class="card-header">
                    <h5>Utilisateurs récents</h5>
            </div>
            <div class="card-body">
                    <div class="table-container">
                        <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Nom</th>
                                <th>Email</th>
                                <th>Date d'inscription</th>
                            </tr>
                        </thead>
                        <tbody>
                                <?php if (isset($recentUsers) && is_array($recentUsers)): ?>
                                    <?php foreach ($recentUsers as $user): ?>
                                        <tr>
                                            <td><?= $user['id'] ?></td>
                                            <td><?= htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) ?></td>
                                            <td><?= htmlspecialchars($user['email']) ?></td>
                                            <td><?= date('Y-m-d', strtotime($user['created_at'])) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4" style="text-align: center;">Aucun utilisateur récent</td>
                                </tr>
                                <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                    <a href="<?= APP_URL ?>/admin/users" class="btn" style="margin-top: 15px;">Gérer les utilisateurs</a>
        </div>
    </div>
</div>

        <div class="card">
            <div class="card-header">
                <h5>Actions rapides</h5>
            </div>
            <div class="card-body">
                <div class="actions-grid">
                    <a href="<?= APP_URL ?>/admin/diseases" class="btn">
                        <i class="fas fa-virus"></i>Gérer les maladies
                    </a>
                    <a href="<?= APP_URL ?>/admin/symptoms" class="btn btn-success">
                        <i class="fas fa-notes-medical"></i>Gérer les symptômes
                    </a>
                    <a href="<?= APP_URL ?>/admin/relations" class="btn btn-info">
                        <i class="fas fa-link"></i>Gérer les relations
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>

<script>
document.addEventListener('DOMContentLoaded', function() {

      // Gestion des dropdown menus dans la navbar
      const navbarDropdown = document.getElementById('navbarDropdown');
    const userDropdown = document.getElementById('userDropdown');
    
    if (navbarDropdown && userDropdown) {
        // Afficher/masquer le dropdown au clic
        navbarDropdown.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            userDropdown.classList.toggle('show');
        });

        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            if (!navbarDropdown.contains(e.target) && !userDropdown.contains(e.target)) {
                userDropdown.classList.remove('show');
            }
        });
    }

});
</script>
</html> 