<?php
// Récupérer les données de l'utilisateur depuis les données passées par le contrôleur
$userModel = new User();
$userId = $_SESSION['user_id'] ?? 0;
$user = isset($user) ? $user : $userModel->getUserById($userId);

// Si l'utilisateur n'est pas trouvé, rediriger vers la page de connexion
if (!$user) {
    header('Location: ' . APP_URL . '/auth/login');
    exit;
}

// Récupérer le nombre de diagnostics si l'utilisateur n'est pas admin
$diagnosticCount = 0;
$isAdmin = isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';

if (!$isAdmin) {
    $diagnosticModel = new Diagnostic();
    $diagnosticCount = $diagnosticModel->countUserDiagnostics($userId);
}

// Récupère les messages d'erreur ou de succès
$success = isset($_SESSION['success']) ? $_SESSION['success'] : null;
$error = isset($_SESSION['error']) ? $_SESSION['error'] : null;

// Efface les messages après les avoir récupérés
unset($_SESSION['success'], $_SESSION['error']);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mon Profil</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4e73df;
            --primary-dark: #3a56b5;
            --secondary-color: #f8f9fc;
            --success-color: #1cc88a;
            --danger-color: #e74a3b;
            --warning-color: #f6c23e;
            --info-color: #36b9cc;
            --dark-color: #5a5c69;
            --light-color: #f8f9fc;
            --border-color: #e3e6f0;
            --text-color: #6e707e;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Nunito', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            background-color: var(--secondary-color);
            color: var(--text-color);
            line-height: 1.6;
        }

        .container {
            max-width: 1140px;
            margin: 0 auto;
            padding: 30px 15px;
        }

        .page-header {
            margin-bottom: 30px;
        }

        .page-header h1 {
            font-size: 1.75rem;
            color: var(--dark-color);
            font-weight: 700;
            margin-bottom: 5px;
        }

        .profile-grid {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 30px;
        }

        .card {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0.15rem 1.75rem rgba(58, 59, 69, 0.15);
            margin-bottom: 30px;
            overflow: hidden;
        }

        .card-header {
            background-color: #f8f9fc;
            padding: 15px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
        }

        .card-header-icon {
            color: var(--primary-color);
            margin-right: 10px;
            font-size: 1.1rem;
        }

        .card-header h2 {
            font-size: 1.1rem;
            color: var(--dark-color);
            margin: 0;
            font-weight: 700;
        }

        .card-body {
            padding: 20px;
        }

        .profile-sidebar {
            text-align: center;
        }

        .profile-avatar {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            margin: 0 auto 20px;
            overflow: hidden;
            border: 4px solid #fff;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }

        .profile-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .profile-info {
            margin-bottom: 20px;
        }

        .profile-name {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--dark-color);
            margin-bottom: 5px;
        }

        .profile-email {
            color: var(--text-color);
            margin-bottom: 5px;
        }

        .member-since {
            font-size: 0.9rem;
            color: var(--text-color);
            margin-bottom: 20px;
        }

        .profile-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            margin-bottom: 20px;
        }

        .stat-item {
            background-color: var(--secondary-color);
            padding: 15px;
            border-radius: 5px;
        }

        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary-color);
        }

        .stat-label {
            font-size: 0.8rem;
            color: var(--text-color);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--dark-color);
        }

        .form-control {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            font-size: 1rem;
            color: var(--dark-color);
            transition: border-color 0.15s ease-in-out;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            outline: 0;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .form-control:disabled {
            background-color: var(--secondary-color);
            cursor: not-allowed;
        }

        .form-row {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .btn {
            display: inline-block;
            font-weight: 600;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            user-select: none;
            background-color: var(--primary-color);
            border: 1px solid transparent;
            padding: 10px 20px;
            font-size: 1rem;
            line-height: 1.5;
            border-radius: 5px;
            transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out;
            cursor: pointer;
        }

        .btn:hover {
            background-color: var(--primary-dark);
        }

        .btn-block {
            display: block;
            width: 100%;
        }

        .btn-success {
            background-color: var(--success-color);
        }

        .btn-success:hover {
            background-color: #169b6b;
        }

        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            border-left: 5px solid transparent;
        }

        .alert-success {
            background-color: rgba(28, 200, 138, 0.1);
            border-left-color: var(--success-color);
            color: #169b6b;
        }

        .alert-danger {
            background-color: rgba(231, 74, 59, 0.1);
            border-left-color: var(--danger-color);
            color: #be2617;
        }

        .text-danger {
            color: var(--danger-color);
        }

        .text-center {
            text-align: center;
        }

        .mt-3 {
            margin-top: 1rem;
        }

        .mb-3 {
            margin-bottom: 1rem;
        }

        .diagnostic-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: var(--primary-color);
            color: white;
            text-decoration: none;
            padding: 12px 20px;
            border-radius: 5px;
            font-weight: 600;
            transition: background-color 0.3s;
        }

        .diagnostic-btn:hover {
            background-color: var(--primary-dark);
        }

        .diagnostic-btn i {
            margin-right: 10px;
        }

        .password-toggle {
            position: relative;
        }

        .password-toggle .toggle-btn {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            color: var(--text-color);
        }

        @media (max-width: 768px) {
            .profile-grid {
                grid-template-columns: 1fr;
            }

            .form-row {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .page-header h1 {
                font-size: 1.5rem;
            }

            .profile-avatar {
                width: 120px;
                height: 120px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="page-header">
            <h1>Mon Profil</h1>
            <p>Gérez vos informations personnelles et vos préférences de comptes</p>
        </div>
        
        <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?= $success ?>
        </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?= $error ?>
        </div>
        <?php endif; ?>
        
        <div class="profile-grid">
            <div class="profile-sidebar">
                <div class="card">
                    <div class="card-body">
                        <div class="profile-avatar">
                            <img src="https://ui-avatars.com/api/?name=<?= urlencode($user['first_name'] . '+' . $user['last_name']) ?>&background=4e73df&color=fff&size=150" alt="Avatar">
                        </div>
                        <div class="profile-info">
                            <h3 class="profile-name"><?= htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) ?></h3>
                            <p class="profile-email"><?= htmlspecialchars($user['email']) ?></p>
                            <p class="member-since">Membre depuis <?= date('d/m/Y', strtotime($user['created_at'])) ?></p>
                        </div>
                        
                        <?php if (!$isAdmin): ?>
                        <div class="profile-stats">
                            <div class="stat-item">
                                <div class="stat-value"><?= $diagnosticCount ?></div>
                                <div class="stat-label">Diagnostics</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-value">0</div>
                                <div class="stat-label">Consultations</div>
                            </div>
                        </div>
                        
                        <a href="<?= APP_URL ?>/diagnostic/history" class="diagnostic-btn">
                            <i class="fas fa-history"></i> Historique de diagnostics
                        </a>
                        <?php else: ?>
                        <div style="margin-top: 20px;">
                            <a href="<?= APP_URL ?>/admin" class="diagnostic-btn">
                                <i class="fas fa-tachometer-alt"></i> Tableau de bord Admin
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="profile-content">
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-user-edit card-header-icon"></i>
                        <h2>Informations personnelles</h2>
                    </div>
                    <div class="card-body">
                        <form id="profileForm" action="<?= APP_URL ?>/auth/profile" method="POST">
                            <input type="hidden" name="action" value="update_profile">
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="first_name">Prénom</label>
                                    <input type="text" class="form-control" id="first_name" name="first_name" value="<?= htmlspecialchars($user['first_name']) ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="last_name">Nom</label>
                                    <input type="text" class="form-control" id="last_name" name="last_name" value="<?= htmlspecialchars($user['last_name']) ?>" required>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="email">Adresse email</label>
                                <input type="email" class="form-control" id="email" value="<?= htmlspecialchars($user['email']) ?>" disabled>
                                <small>L'adresse email ne peut pas être modifiée.</small>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Enregistrer les modifications
                            </button>
                        </form>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-key card-header-icon"></i>
                        <h2>Modifier le mot de passe</h2>
                    </div>
                    <div class="card-body">
                        <form id="passwordForm" action="<?= APP_URL ?>/auth/profile" method="POST">
                            <input type="hidden" name="action" value="update_password">
                            
                            <div class="form-group">
                                <label for="current_password">Mot de passe actuel</label>
                                <div class="password-toggle">
                                    <input type="password" class="form-control" id="current_password" name="current_password" required>
                                    <button type="button" class="toggle-btn" data-target="current_password">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="new_password">Nouveau mot de passe</label>
                                <div class="password-toggle">
                                    <input type="password" class="form-control" id="new_password" name="new_password" required>
                                    <button type="button" class="toggle-btn" data-target="new_password">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                                <small id="password-strength"></small>
                            </div>
                            
                            <div class="form-group">
                                <label for="confirm_password">Confirmer le nouveau mot de passe</label>
                                <div class="password-toggle">
                                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                    <button type="button" class="toggle-btn" data-target="confirm_password">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                                <small id="password-match" class="text-danger"></small>
                            </div>
                            
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-key"></i> Changer le mot de passe
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Stockage des valeurs initiales pour comparaison
            const initialFirstName = document.getElementById('first_name').value;
            const initialLastName = document.getElementById('last_name').value;
            
            // Validation du formulaire de profil
            const profileForm = document.getElementById('profileForm');
            if (profileForm) {
                profileForm.addEventListener('submit', function(e) {
                    const firstName = document.getElementById('first_name').value.trim();
                    const lastName = document.getElementById('last_name').value.trim();
                    
                    if (firstName === '' || lastName === '') {
                        e.preventDefault();
                        alert('Veuillez remplir tous les champs obligatoires.');
                        return;
                    }
                    
                    // Vérifier si les valeurs ont changé
                    if (firstName === initialFirstName && lastName === initialLastName) {
                        e.preventDefault();
                        alert('Aucune modification détectée.');
                        return;
                    }
                });
            }
            
            // Validation du formulaire de mot de passe
            const passwordForm = document.getElementById('passwordForm');
            const newPassword = document.getElementById('new_password');
            const confirmPassword = document.getElementById('confirm_password');
            const passwordMatch = document.getElementById('password-match');
            const passwordStrength = document.getElementById('password-strength');
            
            if (passwordForm) {
                // Vérification en temps réel de la correspondance des mots de passe
                confirmPassword.addEventListener('input', function() {
                    if (this.value === newPassword.value) {
                        passwordMatch.textContent = 'Les mots de passe correspondent';
                        passwordMatch.className = 'text-success';
                    } else {
                        passwordMatch.textContent = 'Les mots de passe ne correspondent pas';
                        passwordMatch.className = 'text-danger';
                    }
                });
                
                // Vérification de la force du mot de passe
                newPassword.addEventListener('input', function() {
                    const password = this.value;
                    let strength = 0;
                    
                    if (password.length >= 8) strength += 1;
                    if (password.match(/[A-Z]/)) strength += 1;
                    if (password.match(/[a-z]/)) strength += 1;
                    if (password.match(/[0-9]/)) strength += 1;
                    if (password.match(/[^A-Za-z0-9]/)) strength += 1;
                    
                    const strengthText = ['Très faible', 'Faible', 'Moyen', 'Fort', 'Très fort'];
                    const strengthColor = ['#e74a3b', '#f6c23e', '#f6c23e', '#1cc88a', '#1cc88a'];
                    
                    if (password.length > 0) {
                        passwordStrength.textContent = 'Force du mot de passe: ' + strengthText[strength - 1];
                        passwordStrength.style.color = strengthColor[strength - 1];
                    } else {
                        passwordStrength.textContent = '';
                    }
                });
                
                // Validation du formulaire avant soumission
                passwordForm.addEventListener('submit', function(e) {
                    const currentPassword = document.getElementById('current_password').value;
                    
                    if (currentPassword === '' || newPassword.value === '' || confirmPassword.value === '') {
                        e.preventDefault();
                        alert('Veuillez remplir tous les champs du formulaire.');
                        return;
                    }
                    
                    if (newPassword.value !== confirmPassword.value) {
                        e.preventDefault();
                        alert('Les mots de passe ne correspondent pas.');
                        return;
                    }
                    
                    if (newPassword.value.length < 8) {
                        e.preventDefault();
                        alert('Le mot de passe doit contenir au moins 8 caractères.');
                        return;
                    }
                });
            }
            
            // Afficher/masquer les mots de passe
            const toggleButtons = document.querySelectorAll('.toggle-btn');
            toggleButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetId = this.getAttribute('data-target');
                    const input = document.getElementById(targetId);
                    const icon = this.querySelector('i');
                    
                    if (input.type === 'password') {
                        input.type = 'text';
                        icon.className = 'fas fa-eye-slash';
                    } else {
                        input.type = 'password';
                        icon.className = 'fas fa-eye';
                    }
                });
            });
        });
    </script>
</body>
</html> 