<?php
$title = 'Détails du Diagnostic';
?>

<style>
    :root {
        --primary-color: #007bff;
        --secondary-color: #6c757d;
        --success-color: #28a745;
        --warning-color: #ffc107;
        --danger-color: #dc3545;
        --light-color: #f8f9fa;
        --dark-color: #343a40;
        --border-color: #dee2e6;
    }

    .container {
        max-width: 1000px;
        margin: 2rem auto;
        padding: 0 1rem;
    }

    .details-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        padding: 2rem;
        margin-bottom: 2rem;
    }

    .details-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        flex-wrap: wrap;
    }

    .details-header h2 {
        color: var(--primary-color);
        margin: 0;
    }

    .btn {
        display: inline-flex;
        align-items: center;
        padding: 0.5rem 1rem;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        text-decoration: none;
        font-weight: 500;
        transition: background-color 0.3s;
    }

    .btn i {
        margin-right: 0.5rem;
    }

    .btn-secondary {
        background-color: var(--secondary-color);
        color: white;
    }

    .btn-secondary:hover {
        background-color: #5a6268;
    }

    .info-section {
        margin-bottom: 2rem;
    }

    .info-title {
        font-size: 1.25rem;
        color: var(--dark-color);
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid var(--border-color);
    }

    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 1rem;
    }

    .info-item {
        padding: 1rem;
        background-color: var(--light-color);
        border-radius: 4px;
        display: flex;
        align-items: center;
    }

    .info-item i {
        margin-right: 0.5rem;
        color: var(--primary-color);
    }

    .results-section {
        margin-top: 2rem;
    }

    .results-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 1rem;
    }

    .results-table th, 
    .results-table td {
        padding: 0.75rem;
        text-align: left;
        border-bottom: 1px solid var(--border-color);
    }

    .results-table th {
        background-color: var(--light-color);
        font-weight: 600;
    }

    .results-table tr:hover {
        background-color: rgba(0, 123, 255, 0.05);
    }

    .disease-name {
        font-weight: 500;
    }

    .probability {
        display: inline-block;
        padding: 0.25rem 0.5rem;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        text-align: center;
        min-width: 60px;
    }

    .probability-high {
        background-color: var(--danger-color);
        color: white;
    }

    .probability-medium {
        background-color: var(--warning-color);
        color: #212529;
    }

    .probability-low {
        background-color: var(--success-color);
        color: white;
    }

    .symptoms-list {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
        margin-top: 1rem;
    }

    .symptom-tag {
        background-color: var(--light-color);
        color: var(--dark-color);
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-size: 0.85rem;
    }

    .disclaimer {
        margin-top: 2rem;
        padding: 1rem;
        background-color: #f8d7da;
        color: #721c24;
        border-radius: 4px;
        font-size: 0.9rem;
    }

    .disclaimer h4 {
        margin-top: 0;
        margin-bottom: 0.5rem;
    }

    @media (max-width: 768px) {
        .details-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 1rem;
        }

        .info-grid {
            grid-template-columns: 1fr;
        }

        .results-table, 
        .results-table thead, 
        .results-table tbody, 
        .results-table th, 
        .results-table td, 
        .results-table tr {
            display: block;
        }

        .results-table thead tr {
            position: absolute;
            top: -9999px;
            left: -9999px;
        }

        .results-table tr {
            border: 1px solid var(--border-color);
            margin-bottom: 1rem;
            border-radius: 4px;
        }

        .results-table td {
            border: none;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            padding-left: 50%;
        }

        .results-table td:before {
            position: absolute;
            top: 12px;
            left: 6px;
            width: 45%;
            padding-right: 10px;
            white-space: nowrap;
            font-weight: 600;
        }

        .results-table td:nth-of-type(1):before { content: "Maladie"; }
        .results-table td:nth-of-type(2):before { content: "Probabilité"; }
    }
</style>

<div class="container">
    <div class="details-card">
        <div class="details-header">
            <h2>Détails du Diagnostic</h2>
            <a href="<?= APP_URL ?>/diagnostic/history" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i>
                Retour à l'historique
            </a>
        </div>
                
        <div class="info-section">
            <h3 class="info-title">Informations générales</h3>
            <div class="info-grid">
                <div class="info-item">
                    <i class="fas fa-calendar"></i>
                    <span>Date: <?= date('d/m/Y H:i', strtotime($diagnostic['date'])) ?></span>
                </div>
                <div class="info-item">
                    <i class="fas fa-user-md"></i>
                    <span>Patient: <?= htmlspecialchars($_SESSION['user_name'] ?? 'Utilisateur') ?></span>
                </div>
            </div>
        </div>

        <div class="info-section">
            <h3 class="info-title">Symptômes sélectionnés</h3>
            <div class="symptoms-list">
                <?php if (isset($diagnostic['symptoms']) && is_array($diagnostic['symptoms'])): ?>
                    <?php foreach ($diagnostic['symptoms'] as $symptom): ?>
                        <span class="symptom-tag"><?= htmlspecialchars($symptom) ?></span>
                    <?php endforeach; ?>
                <?php else: ?>
                    <span>Aucun symptôme enregistré</span>
                <?php endif; ?>
            </div>
        </div>

        <div class="results-section">
            <h3 class="info-title">Résultats du diagnostic</h3>
            <?php if (isset($diagnostic['possible_diseases']) && is_array($diagnostic['possible_diseases']) && !empty($diagnostic['possible_diseases'])): ?>
                <table class="results-table">
                    <thead>
                        <tr>
                            <th>Maladie</th>
                            <th>Probabilité</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($diagnostic['possible_diseases'] as $disease): ?>
                            <?php
                            $probabilityClass = '';
                            $probability = (float)$disease['probability'];
                            if ($probability >= 75) {
                                $probabilityClass = 'probability-high';
                            } elseif ($probability >= 50) {
                                $probabilityClass = 'probability-medium';
                            } else {
                                $probabilityClass = 'probability-low';
                            }
                            ?>
                            <tr>
                                <td class="disease-name"><?= htmlspecialchars($disease['name']) ?></td>
                                <td>
                                    <span class="probability <?= $probabilityClass ?>">
                                        <?= number_format($probability, 1) ?>%
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>Aucune maladie correspondante n'a été trouvée dans notre base de données.</p>
            <?php endif; ?>
        </div>

        <div class="disclaimer">
            <h4><i class="fas fa-exclamation-triangle"></i> Avertissement médical</h4>
            <p>
                Ce diagnostic est généré automatiquement en fonction des symptômes déclarés et ne constitue pas un avis médical professionnel.
                Veuillez consulter un médecin pour une évaluation précise et un traitement approprié.
            </p>
        </div>
    </div>
</div> 

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Gestion des dropdown menus dans la navbar
    const navbarDropdown = document.getElementById('navbarDropdown');
    const userDropdown = document.getElementById('userDropdown');
    
    if (navbarDropdown && userDropdown) {
        // Afficher/masquer le dropdown au clic
        navbarDropdown.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            userDropdown.classList.toggle('show');
        });
        
        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            if (!navbarDropdown.contains(e.target) && !userDropdown.contains(e.target)) {
                userDropdown.classList.remove('show');
            }
        });
    }
});
</script> 
