<?php
$title = 'Résultats du Diagnostic';
?>

<style>
    :root {
        --primary-color: #007bff;
        --success-color: #28a745;
        --warning-color: #ffc107;
        --danger-color: #dc3545;
        --light-color: #f8f9fa;
        --border-color: #dee2e6;
    }

    .container {
        max-width: 1200px;
  margin: 0 auto;
  padding: 20px;
    }

    .results-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        padding: 2rem;
        margin-bottom: 2rem;
    }

    .results-header {
        text-align: center;
        margin-bottom: 2rem;
    }

    .results-header h2 {
        color: var(--primary-color);
        margin-bottom: 0.5rem;
    }

    .symptoms-list {
        margin: 1.5rem 0;
        padding: 1rem;
        background: var(--light-color);
        border-radius: 4px;
    }

    .symptoms-list h3 {
        margin-bottom: 1rem;
        color: #495057;
    }

    .symptoms-list ul {
        list-style: none;
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 0.5rem;
    }

    .symptoms-list li {
        padding: 0.5rem;
        background: white;
        border: 1px solid var(--border-color);
        border-radius: 4px;
        display: flex;
        align-items: center;
    }

    .symptoms-list li i {
        margin-right: 0.5rem;
        color: var(--primary-color);
    }

    .diagnosis-results {
        margin-top: 2rem;
    }

    .diagnosis-item {
        padding: 1rem;
        margin-bottom: 1rem;
        border: 1px solid var(--border-color);
        border-radius: 4px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .diagnosis-item:last-child {
        margin-bottom: 0;
    }

    .disease-name {
        font-weight: 600;
        color: #495057;
    }

    .probability {
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-weight: 600;
        font-size: 0.9rem;
    }

    .probability-high {
        background-color: var(--danger-color);
        color: white;
    }

    .probability-medium {
        background-color: var(--warning-color);
        color: #212529;
    }

    .probability-low {
        background-color: var(--success-color);
        color: white;
    }

    .actions {
        margin-top: 2rem;
        display: flex;
        gap: 1rem;
        justify-content: center;
    }

    .btn {
        display: inline-flex;
        align-items: center;
        padding: 0.5rem 1rem;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        text-decoration: none;
        font-weight: 500;
        transition: background-color 0.3s;
    }

    .btn i {
        margin-right: 0.5rem;
    }

    .btn-primary {
        background-color: var(--primary-color);
        color: white;
    }

    .btn-primary:hover {
        background-color: #0056b3;
    }

    .disclaimer {
        margin-top: 2rem;
        padding: 1rem;
        background-color: #fff3cd;
        border: 1px solid #ffeeba;
        border-radius: 4px;
        color: #856404;
        font-size: 0.9rem;
        text-align: center;
    }

    @media (max-width: 768px) {
        .container {
            padding: 0 0.5rem;
        }

        .symptoms-list ul {
            grid-template-columns: 1fr;
        }

        .actions {
            flex-direction: column;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }
    }
</style>

<div class="container">
    <div class="results-card">
        <div class="results-header">
            <h2>Résultats du Diagnostic</h2>
            <p>Basé sur les symptômes que vous avez sélectionnés</p>
        </div>

        <div class="symptoms-list">
            <h3>Symptômes sélectionnés (<?= count((array)$selectedSymptoms) ?>):</h3>
            <ul>
                <?php foreach ((array)$selectedSymptoms as $symptomId => $symptomName): ?>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        <span style="font-weight: 500; color: #007bff;"><?= htmlspecialchars($symptomName) ?></span>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <div class="diagnosis-results">
            <h3>Maladies possibles :</h3>
            <?php if (empty($results['possible_diseases'])): ?>
                <div style="text-align: center; padding: 20px; background-color: #fff3cd; border-radius: 4px; margin-top: 10px;">
                    <i class="fas fa-exclamation-triangle" style="color: #856404; margin-right: 10px;"></i>
                    <span style="color: #856404;">Aucune maladie correspondant à vos symptômes n'a été trouvée dans notre base de données. Veuillez consulter un professionnel de santé pour un diagnostic plus approfondi.</span>
                </div>
            <?php else: ?>
                <?php foreach ($results['possible_diseases'] as $disease): ?>
                    <?php
                    $probabilityClass = '';
                    if ($disease['probability'] >= 75) {
                        $probabilityClass = 'probability-high';
                    } elseif ($disease['probability'] >= 50) {
                        $probabilityClass = 'probability-medium';
                    } else {
                        $probabilityClass = 'probability-low';
                    }
                    ?>
                    <div class="diagnosis-item">
                        <span class="disease-name"><?= htmlspecialchars($disease['name']) ?></span>
                        <span class="probability <?= $probabilityClass ?>"><?= number_format((float)$disease['probability'], 1) ?>%</span>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div class="actions">
            <a href="<?= APP_URL ?>/diagnostic" class="btn btn-primary">
                <i class="fas fa-redo"></i>
                Nouveau Diagnostic
            </a>
            <?php if (isset($_SESSION['user_id'])): ?>
                <a href="<?= APP_URL ?>/diagnostic/history" class="btn btn-primary">
                    <i class="fas fa-history"></i>
                    Historique
                </a>
            <?php endif; ?>
        </div>

        <div class="disclaimer">
            <strong>Avertissement :</strong> Ce diagnostic est fourni à titre indicatif uniquement. 
            Consultez toujours un professionnel de santé pour un diagnostic médical précis.
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Gestion des dropdown menus dans la navbar
    const navbarDropdown = document.getElementById('navbarDropdown');
    const userDropdown = document.getElementById('userDropdown');
    
    if (navbarDropdown && userDropdown) {
        // Afficher/masquer le dropdown au clic
        navbarDropdown.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            userDropdown.classList.toggle('show');
        });
        
        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            if (!navbarDropdown.contains(e.target) && !userDropdown.contains(e.target)) {
                userDropdown.classList.remove('show');
            }
        });
    }
});
</script> 