<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Résultats de recherche - Historique des diagnostics</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4a90e2;
            --secondary-color: #f5f5f5;
            --text-color: #333;
            --border-color: #ddd;
            --success-color: #28a745;
            --danger-color: #dc3545;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: var(--text-color);
            background-color: var(--secondary-color);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .search-form {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }

        .search-input {
            flex: 1;
            padding: 10px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 16px;
        }

        .search-button {
            padding: 10px 20px;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .search-button:hover {
            background-color: #357abd;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            overflow: hidden;
        }

        .card-header {
            background-color: var(--primary-color);
            color: white;
            padding: 15px 20px;
            font-size: 18px;
            font-weight: bold;
        }

        .card-body {
            padding: 20px;
        }

        .diagnostic-list {
            list-style: none;
        }

        .diagnostic-item {
            border-bottom: 1px solid var(--border-color);
            padding: 15px 0;
        }

        .diagnostic-item:last-child {
            border-bottom: none;
        }

        .diagnostic-date {
            color: #666;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .symptoms-list {
            margin: 10px 0;
            color: #555;
        }

        .probability {
            display: inline-block;
            padding: 4px 8px;
            background-color: var(--success-color);
            color: white;
            border-radius: 4px;
            font-size: 14px;
            margin-left: 10px;
        }

        .no-results {
            text-align: center;
            padding: 40px;
            color: #666;
            font-style: italic;
        }

        .details-link {
            display: inline-block;
            margin-top: 10px;
            color: var(--primary-color);
            text-decoration: none;
        }

        .details-link:hover {
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            .container {
                padding: 10px;
            }

            .search-form {
                flex-direction: column;
            }

            .search-button {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <form action="<?= APP_URL ?>/diagnostic/search" method="GET" class="search-form">
            <input type="text" name="q" class="search-input" placeholder="Rechercher par symptômes ou maladies..." value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
            <button type="submit" class="search-button">
                <i class="fas fa-search"></i> Rechercher
            </button>
        </form>

        <div class="card">
            <div class="card-header">
                Résultats de recherche
            </div>
            <div class="card-body">
                <?php if (empty($diagnostics)): ?>
                    <div class="no-results">
                        Aucun diagnostic trouvé pour votre recherche.
                    </div>
                <?php else: ?>
                    <ul class="diagnostic-list">
                        <?php foreach ($diagnostics as $diagnostic): ?>
                            <li class="diagnostic-item">
                                <div class="diagnostic-date">
                                    <i class="far fa-calendar"></i>
                                    <?= date('d/m/Y H:i', strtotime($diagnostic['created_at'])) ?>
                                </div>
                                <div class="symptoms-list">
                                    <strong>Symptômes :</strong> <?= htmlspecialchars($diagnostic['symptoms']) ?>
                                </div>
                                <div>
                                    <strong>Maladie probable :</strong>
                                    <?= htmlspecialchars($diagnostic['top_disease']) ?>
                                    <span class="probability"><?= number_format($diagnostic['top_probability'] * 100, 1) ?>%</span>
                                </div>
                                <a href="<?= APP_URL ?>/diagnostic/details/<?= $diagnostic['id'] ?>" class="details-link">
                                    Voir les détails <i class="fas fa-chevron-right"></i>
                                </a>
                            </li>
                                <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html> 