<div class="about-container">
    <div class="about-card">
        <div class="card-header">
            <h4><i class="fas fa-info-circle"></i>À propos de <?= APP_NAME ?></h4>
        </div>
        <div class="card-body">
            <h5>Notre mission</h5>
            <p>Notre mission est de rendre les informations médicales et les outils de diagnostic accessibles à tous, afin d'aider les gens à prendre des décisions éclairées concernant leur santé.</p>
            
            <h5>Notre histoire</h5>
            <p><?= APP_NAME ?> a été fondé en 2023 par une équipe de professionnels de la santé et d'ingénieurs en informatique partageant la même vision : créer un outil de diagnostic médical intelligent et accessible à tous.</p>
            <p>Après des années de recherche et de développement, nous avons lancé notre première version de l'application, qui a depuis été continuellement améliorée grâce aux retours des utilisateurs et aux avancées technologiques.</p>
            
            <h5>Notre approche</h5>
            <p>Notre système utilise une combinaison d'intelligence artificielle, d'apprentissage automatique et d'une base de données médicale complète pour analyser les symptômes et identifier les maladies potentielles.</p>
            <p>Nous mettons l'accent sur la précision et la fiabilité des informations fournies, tout en reconnaissant les limites de notre système. C'est pourquoi nous encourageons toujours nos utilisateurs à consulter un professionnel de la santé pour un diagnostic définitif.</p>
            
            <h5>Notre équipe</h5>
            <div class="team-grid">
                <div class="team-member">
                    <img src="https://via.placeholder.com/150" alt="Dr. Jean Dupont" class="member-photo">
                    <h5>Dr. Jean Dupont</h5>
                    <p>Fondateur & Directeur médical</p>
                </div>
                <div class="team-member">
                    <img src="https://via.placeholder.com/150" alt="Marie Martin" class="member-photo">
                    <h5>Marie Martin</h5>
                    <p>Directrice technique</p>
                </div>
                <div class="team-member">
                    <img src="https://via.placeholder.com/150" alt="Pierre Leclerc" class="member-photo">
                    <h5>Pierre Leclerc</h5>
                    <p>Responsable de la recherche</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="commitment-container">
    <div class="commitment-card">
        <div class="card-header">
            <h5><i class="fas fa-shield-alt"></i>Notre engagement</h5>
        </div>
        <div class="card-body">
            <p>Nous nous engageons à :</p>
            <ul>
                <li>Fournir des informations médicales précises et à jour</li>
                <li>Protéger la confidentialité et la sécurité des données de nos utilisateurs</li>
                <li>Améliorer continuellement notre système en fonction des retours des utilisateurs et des avancées médicales</li>
                <li>Maintenir une transparence totale concernant les limites de notre système</li>
                <li>Collaborer avec des professionnels de la santé pour valider nos algorithmes et nos bases de données</li>
            </ul>
        </div>
    </div>
</div>

<style>
.about-container, .commitment-container {
    margin-bottom: 2rem;
}

.about-card, .commitment-card {
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.card-header {
    background-color: #007bff;
    color: white;
    padding: 1rem;
    border-radius: 0.3rem 0.3rem 0 0;
}

.card-header h4, .card-header h5 {
    margin: 0;
}

.card-body {
    padding: 1.5rem;
}

.card-body h5 {
    border-bottom: 1px solid #dee2e6;
    padding-bottom: 0.5rem;
    margin-bottom: 1rem;
}

.team-grid {
    display: flex;
    flex-wrap: wrap;
    gap: 1.5rem;
    margin-top: 1.5rem;
}

.team-member {
    flex: 1;
    min-width: 200px;
    text-align: center;
}

.member-photo {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    margin-bottom: 1rem;
}

.team-member h5 {
    margin-bottom: 0.5rem;
    border: none;
    padding: 0;
}

.team-member p {
    color: #6c757d;
    margin: 0;
}

.commitment-card ul {
    padding-left: 1.5rem;
    margin: 0;
}

.commitment-card li {
    margin-bottom: 0.5rem;
}

@media (max-width: 768px) {
    .team-grid {
        flex-direction: column;
    }
    
    .team-member {
        width: 100%;
    }
}
</style> 