<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?> - <?= $title ?? 'Admin' ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="<?= APP_URL ?>/assets/css/style.css">
    <style>
        :root {
            --primary-color: #007bff;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
            --border-color: #dee2e6;
            --sidebar-width: 250px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
            color: #333;
            display: flex;
            min-height: 100vh;
        }

        .sidebar {
            width: var(--sidebar-width);
            background-color: var(--dark-color);
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
            transition: all 0.3s;
            z-index: 1000;
        }

        .sidebar-header {
            padding: 1.5rem 1rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .sidebar-header h3 {
            font-size: 1.5rem;
            color: white;
            margin: 0;
        }

        .sidebar-menu {
            padding: 1rem 0;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 0.75rem 1.5rem;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s;
        }

        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .sidebar-menu i {
            margin-right: 0.75rem;
            width: 20px;
            text-align: center;
        }

        .content-wrapper {
            flex: 1;
            margin-left: var(--sidebar-width);
            transition: all 0.3s;
            width: calc(100% - var(--sidebar-width));
        }

        .content {
            padding: 2rem;
        }

        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem 2rem;
            background-color: white;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .user-dropdown {
            position: relative;
        }

        .user-menu {
            display: flex;
            align-items: center;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 4px;
        }

        .user-menu:hover {
            background-color: var(--light-color);
        }

        .user-menu img {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            margin-right: 0.5rem;
        }

        .user-menu span {
            margin-right: 0.5rem;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            top: 100%;
            min-width: 200px;
            background-color: white;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            border-radius: 4px;
            z-index: 1000;
        }

        .dropdown-content a {
            display: flex;
            align-items: center;
            padding: 0.75rem 1.5rem;
            color: var(--dark-color);
            text-decoration: none;
        }

        .dropdown-content a:hover {
            background-color: var(--light-color);
        }

        .dropdown-content a i {
            margin-right: 0.75rem;
            width: 20px;
            text-align: center;
        }

        .user-dropdown:hover .dropdown-content {
            display: block;
        }

        .menu-toggle {
            display: none;
            background: none;
            border: none;
            color: var(--dark-color);
            font-size: 1.5rem;
            cursor: pointer;
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: calc(var(--sidebar-width) * -1);
            }

            .content-wrapper {
                margin-left: 0;
                width: 100%;
            }

            .menu-toggle {
                display: block;
            }

            .sidebar.active {
                margin-left: 0;
            }

            .sidebar.active + .content-wrapper {
                margin-left: var(--sidebar-width);
            }
        }
    </style>
</head>
<body>
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h3><?= APP_NAME ?></h3>
            <button class="menu-toggle" id="close-sidebar">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="sidebar-menu">
            <a href="<?= APP_URL ?>/admin" class="<?= $active_menu === 'dashboard' ? 'active' : '' ?>">
                <i class="fas fa-tachometer-alt"></i>
                <span>Tableau de bord</span>
            </a>
            <a href="<?= APP_URL ?>/admin/diseases" class="<?= $active_menu === 'diseases' ? 'active' : '' ?>">
                <i class="fas fa-disease"></i>
                <span>Maladies</span>
            </a>
            <a href="<?= APP_URL ?>/admin/symptoms" class="<?= $active_menu === 'symptoms' ? 'active' : '' ?>">
                <i class="fas fa-thermometer-half"></i>
                <span>Symptômes</span>
            </a>
            <a href="<?= APP_URL ?>/admin/relations" class="<?= $active_menu === 'relations' ? 'active' : '' ?>">
                <i class="fas fa-project-diagram"></i>
                <span>Relations</span>
            </a>
            <a href="<?= APP_URL ?>/admin/users" class="<?= $active_menu === 'users' ? 'active' : '' ?>">
                <i class="fas fa-users"></i>
                <span>Utilisateurs</span>
            </a>
        </div>
    </div>

    <div class="content-wrapper">
        <div class="top-bar">
            <button class="menu-toggle" id="show-sidebar">
                <i class="fas fa-bars"></i>
            </button>
            <div class="user-dropdown">
                <div class="user-menu">
                    <img src="https://ui-avatars.com/api/?name=<?= urlencode($_SESSION['user_name'] ?? 'Admin User') ?>&background=random" alt="User">
                    <span><?= $_SESSION['user_name'] ?? 'Admin User' ?></span>
                    <i class="fas fa-chevron-down"></i>
                </div>
                <div class="dropdown-content">
                    <a href="<?= APP_URL ?>/auth/profile">
                        <i class="fas fa-user"></i>
                        <span>Mon profil</span>
                    </a>
                    <a href="<?= APP_URL ?>/auth/logout">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>Déconnexion</span>
                    </a>
                </div>
            </div>
                </div>
                
        <div class="content">
                <?php require_once APP_ROOT . '/views/partials/alerts.php'; ?>
            <?= $content ?? '' ?>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const showSidebar = document.getElementById('show-sidebar');
            const closeSidebar = document.getElementById('close-sidebar');
            const sidebar = document.getElementById('sidebar');

            showSidebar.addEventListener('click', function() {
                sidebar.classList.add('active');
            });

            closeSidebar.addEventListener('click', function() {
                sidebar.classList.remove('active');
            });

            // Close sidebar when clicking outside on mobile
            document.addEventListener('click', function(event) {
                if (window.innerWidth <= 768) {
                    if (!sidebar.contains(event.target) && event.target !== showSidebar) {
                        sidebar.classList.remove('active');
                    }
                }
            });
        });
    </script>
</body>
</html> 