<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - <?= $title ?? 'Accueil' ?></title>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>/css/style.css">
</head>
<body>
    <header>
        <nav class="navbar">
            <div class="container">
                <a class="navbar-brand" href="<?php echo APP_URL; ?>"><?php echo APP_NAME; ?></a>
                <button class="nav-toggle" id="navToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <div class="nav-menu" id="navMenu">
                    <ul class="nav-list">
                        <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>"><i class="fas fa-home me-1"></i>Accueil</a></li>
                        <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>/about"><i class="fas fa-info-circle me-1"></i>À propos</a></li>
                        <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>/contact"><i class="fas fa-envelope me-1"></i>Contact</a></li>
                        <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>/faq"><i class="fas fa-question-circle me-1"></i>FAQ</a></li>
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>/diagnostic"><i class="fas fa-stethoscope me-1"></i>Diagnostic</a></li>
                        <?php endif; ?>
                    </ul>
                    <ul class="nav-list">
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
                                <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>/admin"><i class="fas fa-cogs me-1"></i>Administration</a></li>
                            <?php endif; ?>
                            <li class="nav-item dropdown">
                                <a class="nav-link" href="#" id="navbarDropdown" onclick="toggleDropdown()">
                                    <i class="fas fa-user me-1"></i><?= $_SESSION['user_email'] ?? 'Mon compte' ?>
                                </a>
                                <ul class="dropdown-menu" id="userDropdown">
                                    <li><a class="dropdown-item" href="<?php echo APP_URL; ?>/auth/profile"><i class="fas fa-id-card me-2"></i>Profil</a></li>
                                    <li><a class="dropdown-item" href="<?php echo APP_URL; ?>/diagnostic/history"><i class="fas fa-history me-2"></i>Historique</a></li>
                                    <li class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="<?php echo APP_URL; ?>/auth/logout"><i class="fas fa-sign-out-alt me-2"></i>Déconnexion</a></li>
                                </ul>
                            </li>
                        <?php else: ?>
                            <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>/auth/login"><i class="fas fa-sign-in-alt me-1"></i>Connexion</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo APP_URL; ?>/auth/register"><i class="fas fa-user-plus me-1"></i>Inscription</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>
    </header>
    <main class="container py-4">
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger">
                <?= $_SESSION['error']; ?>
                <?php unset($_SESSION['error']); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success">
                <?= $_SESSION['success']; ?>
                <?php unset($_SESSION['success']); ?>
            </div>
        <?php endif; ?> 