<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Barre de Navigation</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    /* Styles de navigation */
    .navbar {
      background-color: #2c3e50;
      padding: 1rem 0;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
      position: relative;
    }

    .container {
      width: 100%;
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 1rem;
    }

    .navbar-brand {
      color: white;
      font-size: 1.5rem;
      font-weight: bold;
      text-decoration: none;
    }

    .fas {
      margin-right: 0.5rem;
    }

    .nav-toggle {
      display: none;
      background: none;
      border: none;
      color: white;
      font-size: 1.5rem;
      cursor: pointer;
      padding: 0.5rem;
    }

    .nav-menu {
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .nav-list {
      display: flex;
      list-style: none;
      margin: 0;
      padding: 0;
      align-items: center;
    }

    .nav-item {
      margin: 0 0.5rem;
      position: relative;
    }

    .nav-link {
      color: rgba(255, 255, 255, 0.8);
      text-decoration: none;
      padding: 0.5rem 1rem;
      transition: color 0.3s ease;
      display: flex;
      align-items: center;
    }

    .nav-link:hover {
      color: white;
    }

    .nav-icon {
      margin-right: 0.5rem;
    }

    /* Dropdown Menu */
    .dropdown {
      position: relative;
    }

    .dropdown-menu {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      background: white;
      border-radius: 0.25rem;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
      min-width: 220px;
      z-index: 1000;
      margin-top: 5px;
    }

    .dropdown-menu.show {
      display: block !important;
    }

    .dropdown-item {
      display: flex;
      align-items: center;
      padding: 0.75rem 1rem;
      color: #2c3e50;
      text-decoration: none;
      transition: background-color 0.3s ease;
    }

    .dropdown-item:hover {
      background-color: #ecf0f1;
    }

    .dropdown-icon {
      margin-right: 0.75rem;
    }

    .dropdown-divider {
      height: 1px;
      background-color: #ddd;
      margin: 0.5rem 0;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .nav-toggle {
        display: block;
      }

      .nav-menu {
        display: none;
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background-color: #2c3e50;
        padding: 1rem;
        flex-direction: column;
      }

      .nav-menu.show {
        display: flex;
      }

      .nav-list {
        flex-direction: column;
        width: 100%;
      }

      .nav-item {
        margin: 0.5rem 0;
      }

      /* Pour éviter que le dropdown se modifie en mobile, 
         si le dropdown est affiché (.show), on garde ses styles d'origine */
      .dropdown-menu {
        /* Par défaut en mobile on avait défini position: static et background transparent, 
           on ne les applique plus sur le dropdown déjà ouvert */
      }

      .dropdown-menu.show {
        position: absolute;
        right: 0;
        top: 100%;
        background: white;
        border-radius: 0.25rem;
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        min-width: 220px;
        margin-top: 5px;
      }

      .dropdown-item {
        color: rgba(0, 0, 0, 0.8);
      }

      .dropdown-item:hover {
        background-color: #ecf0f1;
        color: #2c3e50;
      }

      .dropdown-divider {
        background-color: #ddd;
      }
    }
  </style>
</head>
<body>

  <nav class="navbar">
      <div class="container">
          <a class="navbar-brand" href="<?= APP_URL ?>"><?= APP_NAME ?></a>
          <button class="nav-toggle" id="navToggle">
              <i class="fas fa-bars"></i>
          </button>
          <div class="nav-menu" id="navMenu">
              <ul class="nav-list">
                  <li class="nav-item">
                      <a class="nav-link" href="<?= APP_URL ?>"><i class="fas fa-home nav-icon"></i>Accueil</a>
                  </li>
                  <li class="nav-item">
                      <a class="nav-link" href="<?= APP_URL ?>/about"><i class="fas fa-info-circle nav-icon"></i>À propos</a>
                  </li>
                  <li class="nav-item">
                      <a class="nav-link" href="<?= APP_URL ?>/contact"><i class="fas fa-envelope nav-icon"></i>Contact</a>
                  </li>
                  <li class="nav-item">
                      <a class="nav-link" href="<?= APP_URL ?>/faq"><i class="fas fa-question-circle nav-icon"></i>FAQ</a>
                  </li>
                  <?php if (isset($_SESSION['user_id']) && $_SESSION['user_role'] !== 'admin'): ?>
                  <li class="nav-item">
                      <a class="nav-link" href="<?= APP_URL ?>/diagnostic"><i class="fas fa-stethoscope nav-icon"></i>Diagnostic</a>
                  </li>
                  <?php endif; ?>
              </ul>
              <ul class="nav-list">
                  <?php if (isset($_SESSION['user_id'])): ?>
                      <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
                      <li class="nav-item">
                          <a class="nav-link" href="<?= APP_URL ?>/admin"><i class="fas fa-cogs nav-icon"></i>Administration</a>
                      </li>
                      <?php endif; ?>
                      <li class="nav-item dropdown">
                          <a class="nav-link" href="#" id="navbarDropdown">
                              <i class="fas fa-user nav-icon"></i>
                          </a>
                          <ul class="dropdown-menu" id="userDropdown">
                              <li><a class="dropdown-item" href="<?= APP_URL ?>/auth/profile"><i class="fas fa-id-card dropdown-icon"></i>Profil</a></li>
                              <?php if ($_SESSION['user_role'] !== 'admin'): ?>
                              <li><a class="dropdown-item" href="<?= APP_URL ?>/diagnostic/history"><i class="fas fa-history dropdown-icon"></i>Historique</a></li>
                              <?php endif; ?>
                              <li class="dropdown-divider"></li>
                              <li><a class="dropdown-item" href="<?= APP_URL ?>/auth/logout"><i class="fas fa-sign-out-alt dropdown-icon"></i>Déconnexion</a></li>
                          </ul>
                      </li>
                  <?php else: ?>
                      <li class="nav-item">
                          <a class="nav-link" href="<?= APP_URL ?>/auth/login"><i class="fas fa-sign-in-alt nav-icon"></i>Connexion</a>
                      </li>
                      <li class="nav-item">
                          <a class="nav-link" href="<?= APP_URL ?>/auth/register"><i class="fas fa-user-plus nav-icon"></i>Inscription</a>
                      </li>
                  <?php endif; ?>
              </ul>
          </div>
      </div>
  </nav>


</body>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Toggle menu sur mobile
        const navToggle = document.getElementById('navToggle');
        const navMenu = document.getElementById('navMenu');
        
        if (navToggle && navMenu) {
            navToggle.addEventListener('click', function() {
                navMenu.classList.toggle('show');
            });
        }
        
        // Gestion du dropdown utilisateur
        const navbarDropdown = document.getElementById('navbarDropdown');
        const userDropdown = document.getElementById('userDropdown');
        
        if (navbarDropdown && userDropdown) {
            // Afficher/masquer le dropdown au clic
            navbarDropdown.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                userDropdown.classList.toggle('show');
            });

              // Empêche la fermeture quand on clique à l’intérieur du menu
        userDropdown.addEventListener('click', function(e) {
            e.stopPropagation();
        });
            
            // Fermer le dropdown si on clique ailleurs
            document.addEventListener('click', function(e) {
                if (!navbarDropdown.contains(e.target) && !userDropdown.contains(e.target)) {
                    userDropdown.classList.remove('show');
                }
            });
        }
    });
  </script> 
</html>
