document.addEventListener('DOMContentLoaded', function() {
    // Gestion des symptômes sélectionnés
    const symptomCards = document.querySelectorAll('.symptom-card');
    if (symptomCards.length > 0) {
        symptomCards.forEach(card => {
            card.addEventListener('click', function() {
                this.classList.toggle('selected');
                updateSelectedSymptoms();
            });
        });
    }

    // Autocomplétion des symptômes
    const symptomSearch = document.getElementById('symptom-search');
    if (symptomSearch) {
        symptomSearch.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const symptoms = document.querySelectorAll('.symptom-card');
            
            symptoms.forEach(symptom => {
                const symptomName = symptom.textContent.toLowerCase();
                if (symptomName.includes(searchTerm)) {
                    symptom.style.display = 'block';
                } else {
                    symptom.style.display = 'none';
                }
            });
        });
    }

    // Gestion des formulaires
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            if (!this.checkValidity()) {
                e.preventDefault();
                showAlert('Veuillez remplir tous les champs requis', 'danger');
            }
        });
    });

    // Fonction pour afficher les alertes
    function showAlert(message, type = 'success') {
        const alertDiv = document.createElement('div');
        alertDiv.className = `alert alert-${type}`;
        alertDiv.textContent = message;
        
        const container = document.querySelector('.container');
        container.insertBefore(alertDiv, container.firstChild);
        
        setTimeout(() => {
            alertDiv.remove();
        }, 5000);
    }

    // Fonction pour mettre à jour les symptômes sélectionnés
    function updateSelectedSymptoms() {
        const selectedSymptoms = document.querySelectorAll('.symptom-card.selected');
        const symptomsInput = document.getElementById('selected-symptoms');
        if (symptomsInput) {
            symptomsInput.value = Array.from(selectedSymptoms)
                .map(card => card.dataset.symptomId)
                .join(',');
        }
    }

    // Gestion des modales
    const modalTriggers = document.querySelectorAll('[data-modal]');
    modalTriggers.forEach(trigger => {
        trigger.addEventListener('click', function() {
            const modalId = this.dataset.modal;
            const modal = document.getElementById(modalId);
            if (modal) {
                modal.style.display = 'block';
            }
        });
    });

    // Fermeture des modales
    const closeButtons = document.querySelectorAll('.modal-close');
    closeButtons.forEach(button => {
        button.addEventListener('click', function() {
            this.closest('.modal').style.display = 'none';
        });
    });

    // Fermeture des modales en cliquant en dehors
    window.addEventListener('click', function(e) {
        if (e.target.classList.contains('modal')) {
            e.target.style.display = 'none';
        }
    });

    // Animation des cartes de résultats
    const diseaseCards = document.querySelectorAll('.disease-card');
    if (diseaseCards.length > 0) {
        diseaseCards.forEach((card, index) => {
            setTimeout(() => {
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, index * 200);
        });
    }

    // Gestion du menu mobile
    const navToggle = document.getElementById('navToggle');
    const navMenu = document.getElementById('navMenu');
    
    if (navToggle && navMenu) {
        navToggle.addEventListener('click', function() {
            navMenu.classList.toggle('show');
        });
    }

    // Gestion des menus déroulants
    const dropdownToggles = document.querySelectorAll('.nav-link[id^="navbarDropdown"]');
    
    dropdownToggles.forEach(function(toggle) {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            const dropdownMenu = this.nextElementSibling;
            dropdownMenu.classList.toggle('show');
            
            // Fermer les autres menus déroulants
            dropdownToggles.forEach(function(otherToggle) {
                if (otherToggle !== toggle) {
                    const otherMenu = otherToggle.nextElementSibling;
                    if (otherMenu.classList.contains('show')) {
                        otherMenu.classList.remove('show');
                    }
                }
            });
        });
    });

    // Fermer les menus déroulants lorsqu'on clique à l'extérieur
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.dropdown')) {
            document.querySelectorAll('.dropdown-menu').forEach(function(menu) {
                menu.classList.remove('show');
            });
        }
        
        if (navToggle && navMenu && !e.target.closest('.navbar')) {
            navMenu.classList.remove('show');
        }
    });

    // Gestion des messages flash
    const flashMessages = document.querySelectorAll('.alert');
    
    if (flashMessages.length > 0) {
        setTimeout(function() {
            flashMessages.forEach(function(message) {
                message.classList.add('fade-out');
                setTimeout(function() {
                    message.remove();
                }, 500);
            });
        }, 5000);
    }

    // Gestion des formulaires de recherche
    const searchForms = document.querySelectorAll('.search-form');
    
    searchForms.forEach(function(form) {
        const searchInput = form.querySelector('input[type="text"]');
        const clearButton = form.querySelector('.search-clear');
        
        if (searchInput && clearButton) {
            // Afficher le bouton de suppression si le champ contient du texte
            searchInput.addEventListener('input', function() {
                if (this.value.length > 0) {
                    clearButton.style.display = 'block';
                } else {
                    clearButton.style.display = 'none';
                }
            });
            
            // Effacer le champ et soumettre le formulaire
            clearButton.addEventListener('click', function() {
                searchInput.value = '';
                clearButton.style.display = 'none';
                form.submit();
            });
        }
    });

    // Fonction pour basculer le menu déroulant
    function toggleDropdown() {
        const dropdown = document.getElementById('userDropdown');
        if (dropdown) {
            dropdown.classList.toggle('show');
        }
    }
}); 